
#ifndef __HIGHSCORE_H__
#define __HIGHSCORE_H__

#include "ldwTypes.h"

class CScore
{
public:
    CScore(ldwUINT32 dwScoreID, const char* szName, ldwUINT32 dwScore, ldwUINT32 dwHours_played, ldwUINT32 pointsEarned,
           ldwUINT32 babiesMade, ldwUINT32 foodGathered, ldwUINT32 peepsCured, ldwUINT32 crabsFound, 
           ldwUINT32 maxPop, ldwUINT32 peepsDied, ldwUINT32 oldestVillager, ldwUINT32 numCrisis,
           ldwUINT32 twinsBirthed, ldwUINT32 tripletsBirthed,ldwUINT32 puzzlesSolved);
    ~CScore();

    char		name[32];
    ldwUINT32 score;
	ldwUINT32 hours_played;
	ldwUINT32 pointsEarned;
	ldwUINT32 babiesMade;
	ldwUINT32 foodGathered;
	ldwUINT32 peepsCured;
	ldwUINT32 crabsFound;
	ldwUINT32 maxPop;
	ldwUINT32 peepsDied;
	ldwUINT32 oldestVillager;
	ldwUINT32 numCrisis;
	ldwUINT32 twinsBirthed;
	ldwUINT32 tripletsBirthed;
	ldwUINT32 puzzlesSolved;
	ldwUINT32 score_id;
};

class CHighScoreImpl;

class CHighScore
{
public:

    CHighScore();
    ~CHighScore();

	//--------------
    // data submission &fetch functions
	//--------------
    bool Submit(CScore *gameScore,ldwUINT32 starttime, ldwUINT32 version, ldwUINT32 global_regtime, const char* reg_name);
    
#ifdef _MAC
	bool QueryCompleted();
	bool QuerySucceeded();
	
	void CancelQuery();
	
#endif
    CScore *GetFirst();

    // message

    const char* GetLastMessage();

private:

	CHighScoreImpl *mHighScore;
};


#endif // __HIGHSCORE_H__
